<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/newsDAL.php";
	require_once "../dal/news_categoryDAL.php";

	class _newsEdit extends pageBase{
		private $id,$pUrl;
		private $dal,$dalC;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('23')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","newsList.php"));
			$this->dal = new newsDAL();
			$this->dalC = new news_categoryDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->NewsID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryID",$this->dal->CategoryID);
				parent::addParameter("Title",$this->dal->Title);
				parent::addParameter("QuoteText",$this->dal->QuoteText);
				parent::addParameter("QuoteLink",$this->dal->QuoteLink);
				parent::addParameter("Introduction",$this->dal->Introduction);
				parent::addParameter("Description",$this->dal->Description);
				parent::addParameter("Image",$this->dal->Image);
				parent::addParameter("OnlineTime",$this->dal->OnlineTime);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("WebTitle",$this->dal->WebTitle);
				parent::addParameter("WebKeyword",$this->dal->WebKeyword);
				parent::addParameter("WebDescription",$this->dal->WebDescription);
				parent::addParameter("editTitle","修改最新消息內容");
			}else{
				parent::addParameter("Visible","1");
				parent::addParameter("OrderNO","100");
				parent::addParameter("editTitle","新增最新消息");
			}

			//分類下拉
			$dataC = $this->dalC->executeRecordset("a.`Visible`='1'");
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/newsEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->NewsID = $this->id;
				$this->dal->loadRecord();
			}else{
				$this->dal->CreatedUserID = parent::getCurrentUserID();
			}
			$this->dal->CategoryID = conver::toDbString(trim($_POST["CategoryID"]));
			$this->dal->Title = conver::toDbString(trim($_POST["Title"]));
			$this->dal->QuoteText = conver::toDbString(trim($_POST["QuoteText"]));
			$this->dal->QuoteLink = conver::toDbString(trim($_POST["QuoteLink"]));
			$this->dal->Introduction = conver::toDbString(trim($_POST["Introduction"]));
			$this->dal->Introduction = str_replace("\r\n","",$this->dal->Introduction);
			$this->dal->Description = conver::toDbString(trim($_POST["Description"]));
			$this->dal->Image = conver::toDbString(trim($_POST["Image"]));
			$onlineTime = conver::toDbString(trim($_POST["OnlineTime"]));
			$this->dal->OnlineTime = (isset($onlineTime) && $onlineTime != "") ? $onlineTime : date("Y-m-d H:i:s");
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"]) ? $_POST["OrderNO"] : 0;
			$this->dal->WebTitle = conver::toDbString(trim($_POST["WebTitle"]));
			$this->dal->WebTitle = str_replace("\r\n","",$this->dal->WebTitle);
			if(trim($this->dal->WebTitle) == "")
				$this->dal->WebTitle = $this->dal->Title;
			$this->dal->WebKeyword = conver::toDbString(trim($_POST["WebKeyword"]));
			$this->dal->WebKeyword = str_replace("\r\n","",$this->dal->WebKeyword);
			if(trim($this->dal->WebKeyword) == ""){
				$this->dalC->CategoryID = $this->dal->CategoryID;
				$this->dalC->loadRecord();
				$this->dal->WebKeyword = $this->dal->Title.",".$this->dalC->CategoryName;
			}
			$this->dal->WebDescription = conver::toDbString(trim($_POST["WebDescription"]));
			$this->dal->WebDescription = str_replace("\r\n","",$this->dal->WebDescription);
			if(trim($this->dal->WebDescription) == "")
				$this->dal->WebDescription = $this->dal->Introduction;
			$this->dal->ModifiedUserID = parent::getCurrentUserID();

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _newsEdit();
	$page->load();
	$page->render();
?>