<?php
	require_once "pageBase.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/menuDAL.php";

	class _menuList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('36')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//
			$dal = new menuDAL();
			$filter = "";
			$orderExp = "b.`OrderNO`,a.`OrderNO`";
			$data = $dal->executeRecordset($filter,$orderExp,0,-1);
			$data = $this->formatData($data);

			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::addParameter("encodeUrl",urlencode( utility::getCurrentUrl()));
			parent::loadTemplateFile(dirname(__FILE__)."/templates/menuList.html");

			//父類方法
			parent::loadData();
		}

		private function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["ParentName"] == ""){
					$data[$i]["ParentName"] = "主功能";
				}
				if($data[$i]["Visible"] == "0"){
					$data[$i]["VisibleName"] = "不使用";
					$data[$i]["CVisible"] = "1";
					$data[$i]["CVisibleName"] = "使用";
				}else{
					$data[$i]["VisibleName"] = "使用";
					$data[$i]["CVisible"] = "0";
					$data[$i]["CVisibleName"] = "不使用";
				}
				$data[$i]["encodeUrl"] = urlencode(utility::getCurrentUrl());
			}
			return $data;
		}
	}

	$page = new _menuList();
	$page->load();
	$page->render();
?>