<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/menuDAL.php";

	class _menuEdit extends pageBase{
		private $dal;
		private $id,$pUrl;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('36')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new menuDAL();
			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","menuList.php"));

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			//
			$dataP = $this->dal->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'","a.`OrderNO`");
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $dataP;
			parent::addControl($listP);

			//
			if($this->id != "" && $this->id != "0"){
				$this->dal->MenuID = $this->id;
				$this->dal->loadRecord();

				parent::addParameter("ParentID",$this->dal->ParentID);
				parent::addParameter("MenuName",$this->dal->MenuName);
				parent::addParameter("MenuIcon",$this->dal->MenuIcon);
				parent::addParameter("MenuLink",$this->dal->MenuLink);
				parent::addParameter("LinkTarget",$this->dal->LinkTarget);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("editTitle","修改功能項目");
			}else{
				parent::addParameter("ParentID","0");
				parent::addParameter("LinkTarget","_self");
				parent::addParameter("Visible","1");
				parent::addParameter("editTitle","新增功能項目");
			}
			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/menuEdit.html");

			//父類方法
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->MenuID = $this->id;
				$this->dal->loadRecord();
			}

			$this->dal->ParentID = conver::toDbString(trim($_POST["ParentID"]));
			$this->dal->MenuName = conver::toDbString(trim($_POST["MenuName"]));
			$this->dal->MenuIcon = conver::toDbString(trim($_POST["MenuIcon"]));
			$this->dal->MenuLink = conver::toDbString(trim($_POST["MenuLink"]));
			$this->dal->LinkTarget = conver::toDbString(trim($_POST["LinkTarget"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric(conver::toDbString(trim($_POST["OrderNO"])))?conver::toDbString(trim($_POST["OrderNO"])):0;

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _menuEdit();
	$page->load();
	$page->render();
?>