<?php
/*--------------------------------------------------------- 
 * File:login.php
 * Author:Tomix
 * Description: 
 * Created:2009
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 
 require_once "pageBase.php";
 require_once "../dal/userDAL.php";
 require_once "../bin/system/utility.php";
 require_once "CCheckCodeFile.php";
 
 class _login extends pageBase
 {
 	//覆蓋父類load()方法
 	public function load()
 	{ 		 		
 		if(parent::isPostBack())
 		{
 			$this->login();
 		}
 		else if($_GET["do"]=="logout")
 		{
 			unset($_SESSION[sessionKeys::$userInfo]);
			unset($_SESSION[sessionKeys::$adminUserID]);
 			parent::redirect("login.php");
 		}
 		else
 		{
 			parent::loadTemplateFile(dirname(__FILE__)."/templates/login.html");
 			
            $c_check_code_image = new CCheckCodeFile();
            $c_check_code_image ->SetCheckImageWH(70,20);//设置显示验证码图片的尺寸
          
            $img =$c_check_code_image ->OutCheckImage(); 
            
 			parent::addParameter("img",$img);
 		} 
 		
 		parent::load();
 	} 
 	
 	//登陸
 	private function login()
 	{
		/* 錯誤鎖定 */
		if(file_exists("loginerror.txt")){
			$errlog = file_get_contents("loginerror.txt");
			if($errlog != ""){
				$aryErr = json_decode($errlog);
			}else{
				$aryErr = array();
			}
		}else{
			$aryErr = array();
		}
		if(!empty($_SERVER['HTTP_CLIENT_IP'])){
			$myip = $_SERVER['HTTP_CLIENT_IP'];
		}else if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
			$myip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		}else{
			$myip= $_SERVER['REMOTE_ADDR'];
		}
		/* 錯誤鎖定 */
		
 		$loginName=trim($_POST["username"]);
 		$password=trim($_POST["password"]);
 		
 		$user=new userDAL();
 		$user->LoginName=$loginName;
 		$user->loadRecord();
 		if(!isset($user->UserID) 
 			|| $user->UserID == "" 
 			|| $user->UserID == 0 
 			|| ($user->Flags & 1) >0
 			|| (($user->UserType & userType::$admin) == 0 && ($user->UserType & userType::$administrator) == 0))
 		{
			/* 錯誤鎖定 */
			$ary = array();
			$ary["Time"] = date("Y-m-d H:i:s");
			$ary["IP"] = $myip;
			$ary["LoginName"] = urlencode($loginName);
			$ary["Password"] = urlencode($password);
			$aryErr[] = $ary;
			$newlog = json_encode($aryErr);
			file_put_contents("loginerror.txt", $newlog);
			/* 錯誤鎖定 */
			
 			parent::alert("用戶不存在,請聯繫管理員!");
 			parent::redirect("login.php");
 		}
 		else if($password!=$user->Password)
 		{
			/* 錯誤鎖定 */
			$ary = array();
			$ary["Time"] = date("Y-m-d H:i:s");
			$ary["IP"] = $myip;
			$ary["LoginName"] = urlencode($loginName);
			$ary["Password"] = urlencode($password);
			$aryErr[] = $ary;
			$newlog = json_encode($aryErr);
			file_put_contents("loginerror.txt", $newlog);
			/* 錯誤鎖定 */
			
 			parent::alert("密碼錯誤,請聯繫管理員!");
 			parent::redirect("login.php");
 		}
		else if($user->Visible != "1")
		{
			/* 錯誤鎖定 */
			$ary = array();
			$ary["Time"] = date("Y-m-d H:i:s");
			$ary["IP"] = $myip;
			$ary["LoginName"] = urlencode($loginName);
			$ary["Password"] = urlencode($password);
			$aryErr[] = $ary;
			$newlog = json_encode($aryErr);
			file_put_contents("loginerror.txt", $newlog);
			/* 錯誤鎖定 */
			
			parent::alert("管理帳號已被停權!");
			parent::redirect("login.php");
		}
 		else
 		{
			/* 錯誤鎖定 */
			if(file_exists("loginerror.txt")){
				rename("loginerror.txt", "loginerror_".time().".txt");
			}
			/* 錯誤鎖定 */
			
 			$info=new userInfo();
 			$info->userID=$user->UserID;
 			$info->loginName=$user->LoginName;
 			$info->userName=$user->UserName;
 			$info->userType=$user->UserType;
 			
			$_SESSION[sessionKeys::$adminUserID]=$user->UserID;	
 			$_SESSION[sessionKeys::$userInfo]=$info;	
 		 			
 			$returnUrl=urldecode(isset($_GET["returnUrl"])? urldecode(trim($_GET["returnUrl"])):"/apple/");
 			parent::redirect($returnUrl);
 			
 		}
 	}
 }
 
 $page=new _login();
 $page->load();
 $page->render(); 
?>
