<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/registryDAL.php";
	class _jumpSet extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('35')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}
		public function loadData(){
			$webJumpType = registryDAL::getRegistryValue("webJumpType");
			if($webJumpType == ''){
				$webJumpType = '0';
			}
			$webJumpImage = registryDAL::getRegistryValue("webJumpImage");
			$webJumpLink = registryDAL::getRegistryValue("webJumpLink");
			parent::addParameter("webJumpType",$webJumpType);
			parent::addParameter("webJumpImage",$webJumpImage);
			parent::addParameter("webJumpLink",$webJumpLink);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/jumpSet.html");
			parent::loadData();
		}
		public function saveData(){
			$webJumpType = conver::toDbString(trim($_POST["webJumpType"]));
			$webJumpImage = conver::toDbString(trim($_POST["webJumpImage"]));
			$webJumpLink = conver::toDbString(trim($_POST["webJumpLink"]));
			registryDAL::saveRegistry("webJumpType",$webJumpType);
			registryDAL::saveRegistry("webJumpImage",$webJumpImage);
			registryDAL::saveRegistry("webJumpLink",$webJumpLink);
			parent::alert2("儲存完畢!","jumpSet.php");
		}
	}

	$page = new _jumpSet();
	$page->load();
	$page->render();
?>