<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/pictureDAL.php";
	require_once "../dal/registryDAL.php";
	class _index_pictureSet extends pageBase{
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('39')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new pictureDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			$pageBannerType = registryDAL::getRegistryValue("pageBannerType");
			parent::addParameter("pageBannerType",$pageBannerType);

			$aryP = array();
			for($i=1;$i<11;$i++){
				$ary = array();
				$this->dal->PictureType = "30";
				$this->dal->TypeOrderNO = $i;
				$this->dal->loadRecord();
				$ary["NO"] = $i;
				$ary["Image"] = $this->dal->Image;
				$ary["Title"] = $this->dal->Title;
				$ary["Link"] = $this->dal->Link;
				$ary["BanColor"] = $this->dal->BanColor;
				$ary["DanDesc"] = $this->dal->DanDesc;
				$aryP[] = $ary;
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $aryP;
			parent::addControl($listP);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/index_pictureSet.html");
			parent::loadData();
		}
		public function saveData(){
			$pageBannerType = conver::toDbString(trim($_POST["pageBannerType"]));
			registryDAL::saveRegistry("pageBannerType",$pageBannerType);

			$this->dal->PictureType = "30";
			for($i=1;$i<11;$i++){
				$this->dal->TypeOrderNO = $i;
				$this->dal->Image = conver::toDbString(trim($_POST["Image".$i]));
				$this->dal->Title = conver::toDbString(trim($_POST["Title".$i]));
				$this->dal->Link = conver::toDbString(trim($_POST["Link".$i]));
				$this->dal->BanColor = conver::toDbString(trim($_POST["BanColor".$i]));
				$this->dal->DanDesc = conver::toDbString(trim($_POST["DanDesc".$i]));
				$this->dal->replaceRecord();
			}

			parent::redirect("index_pictureSet.php");
		}
	}

	$page = new _index_pictureSet();
	$page->load();
	$page->render();
?>