<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/htaccessDAL.php";

	class _htaccessSet extends pageBase{
		private $filename;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('51')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->filename = "../.htaccess";
			$this->dal = new htaccessDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}

		public function loadData(){
			$data = $this->dal->executeRecordset();
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/htaccessSet.html");
			parent::loadData();
		}
		public function saveData(){
			$str = '';
			$id = $_POST["ID"];
			$htmlName = $_POST["HtmlName"];
			$visible = $_POST["Visible"];
			if(count($id) == count($htmlName) && count($id) == count($visible) && count($id) == $this->dal->countRecordset()){
				if(file_exists($this->filename)){
					$file = fopen($this->filename,"r");
					if($file != NULL){
						$flag = 0;
						while(!feof($file)){
							$line = fgets($file);
							if($flag == 0){
								$str .= $line;
								if(strpos($line,"WebSite Page Start") != false){
									$flag = 1;
									for($i=0;$i<count($id);$i++){
										$this->dal->ID = $id[$i];
										$this->dal->loadRecord();
										$this->dal->HtmlName = $htmlName[$i];
										$this->dal->Visible = $visible[$i];
										$this->dal->updateRecord();

										if($this->dal->Visible == "1"){
											switch($this->dal->ActionName){
												case "article":
													$str .= "#article start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			article.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([a-zA-Z0-9\-_]+).html$			article.php?path=$1\n";
													$str .= "#article end\n\n\n";
													break;
												case "news":
													$str .= "#news start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			news.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."_([0-9]+).html$			news.php?p=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+).html$			news.php?id=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+)_([0-9]+).html$			news.php?id=$1&p=$2\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([0-9]+).html$			news-detail.php?id=$1\n";
													$str .= "#news end\n\n\n";
													break;
												case "faq":
													$str .= "#faq start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			faq.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."_([0-9]+).html$			faq.php?p=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+).html$			faq.php?id=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+)_([0-9]+).html$			faq.php?id=$1&p=$2\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([0-9]+).html$			faq-detail.php?id=$1\n";
													$str .= "#faq end\n\n\n";
													break;
												case "product":
													$str .= "#product start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			product.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."_([0-9]+).html$			product.php?p=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+).html$			product.php?id=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+)_([0-9]+).html$			product.php?id=$1&p=$2\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([0-9]+).html$			product-detail.php?id=$1\n";
													$str .= "#product end\n\n\n";
													break;
												case "book":
													$str .= "#book start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			book.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."_([0-9]+).html$			book.php?p=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+).html$			book.php?id=$1\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."([0-9]+)_([0-9]+).html$			book.php?id=$1&p=$2\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([0-9]+).html$			book-detail.php?id=$1\n";
													$str .= "#book end\n\n\n";
													break;
												case "contact":
													$str .= "#contact start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			contact.php\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName."-([0-9]+).html$			contact.php?id=$1\n";
													$str .= "#contact end\n\n\n";
													break;
												case "order":
													$str .= "#order start /".$this->dal->HtmlName."/\n";
													$str .= "RewriteRule ^".$this->dal->HtmlName.".html$			order.php\n";
													$str .= "#order end\n\n\n";
													break;
											}
										}
									}
									$str .= "#no set page start\n";
									$str .= "RewriteRule ^[a-zA-Z0-9\-_].html$			index.php\n";
									$str .= "#no set page end\n\n\n";
								}
							}else if($flag == 1){
								if(strpos($line,"WebSite Page End") != false){
									$str .= $line;
									$flag = 2;
								}
							}else{
								$str .= $line;
							}
						}
						fclose($file);
						if($flag == 0){
							parent::alert2("網頁網址設定原始資料異常!請和管理者聯絡!","htaccessSet.php");
						}else{
							$fileN = fopen($this->filename,"w");
							fwrite($fileN,$str);
							fclose($fileN);
							parent::alert2("修改已儲存","htaccessSet.php");
						}
					}else{
						fclose($file);
						parent::alert2("網頁網址設定原始資料異常!請和管理者聯絡!!","htaccessSet.php");
					}
				}else{
					parent::alert2("網頁網址設定原始資料異常!請和管理者聯絡!!!","htaccessSet.php");
				}
			}else{
				parent::alert2("資料異常!請重新整理再試一次!","htaccessSet.php");
			}
		}
	}

	$page = new _htaccessSet();
	$page->load();
	$page->render();
?>