<?php
	require_once "pageBase.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/faq_categoryDAL.php";

	class _faq_categoryList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('50')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new faq_categoryDAL();

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$data = $this->dal->executeRecordset();
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/faq_categoryList.html");
			parent::loadData();
		}
		public function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["Visible"] == "1")
					$data[$i]["Visible"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["Visible"] = "<span style=\"color:#f00;\">&#10005</span>";

				$data[$i]["htLink"] = $this->htLink3;
			}
			return $data;
		}
	}

	$page = new _faq_categoryList();
	$page->load();
	$page->render();
?>