<?php
	require_once dirname(__FILE__)."/../../bin/configuration/configFactory.php";
	require_once dirname(__FILE__)."/../../bin/system/utility.php";
	require_once dirname(__FILE__)."/../pageBase.php";

	class upload extends pageBase{
		public $id;
		public function load(){
			parent::load();
			$this->id = parent::getPageParameter("id","");
			if(parent::isPostBack()){
				$config = configFactory::createConfiguration();
				$type = trim($config->getConfigValue("appsettings","allowImageType"));		//圖片類型
				$size = trim($config->getConfigValue("appsettings","allowImageSize"));		//文件大小上限
				$baseDir = trim($config->getConfigValue("appsettings","uploadDir"));		//上傳目錄
				$autoDir = trim($config->getConfigValue("appsettings","autoUploadDir"));	//是否創建新目錄

				$baseDir = utility::removeDirSlash($baseDir);
				$baseDir = "../../".$baseDir;
				if(!is_dir($baseDir))
					mkdir($baseDir,0777);
				$saveDir = $baseDir."/files/";
				if($autoDir){
					$saveDir = $baseDir."/".date("Ymd")."/";
					if(!is_dir($saveDir))
						mkdir($saveDir,0777);
				}
				$file = $_FILES["userfile"];
				$fileName = $file["name"];
				$fileExt = "";//後綴
				$fileSize = $file["size"];
				if(strrpos($fileName,"."))
					$fileExt = substr($file["name"],strrpos($file["name"],".")+1);

				if($fileName == ""){
					$this->showMsg("請選擇要上傳的檔案!");
				}else if($fileExt == "" || strpos(strtolower($type),strtolower($fileExt)) === false){
					$this->showMsg("請選擇合適的檔案類型!\\r\\n\\r\\n允許類型為:".$type);
				}else if($size == 0){
					$this->showMsg("系統設置不能上傳檔案，如有疑問請聯繫管理員!");
				}else if($size > 0 && $file["size"] > $size * 1024){
					$this->showMsg("檔案不能大於".$size."KB!");
				}else{
					//$fn = $saveDir.$file["name"];
					$fn = $saveDir.date("YmdHis").floor(microtime()*1000);
					if(strrpos($file["name"],".")){
						$fn .= substr($file["name"],strrpos($file["name"],"."));
					}
					if(!move_uploaded_file($file["tmp_name"],$fn)){
						$this->showMsg("檔案上傳失敗!");
					}else{
						echo "<script language=\"javascript\">";
						echo "parent.upimage(\"".$this->id."\",\"".str_replace("../../","/",$fn)."\");</script>";
						exit;
					}
				}
			}
		}

		private function showMsg($msg){
			echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />";
			echo "<script language=\"javascript\">window.alert(\"".$msg."\");parent.jQuery.fancybox.close();</script>";
		}
	}

	$page = new upload();
	$page->load();
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="expires" content="0">
<base target="_self" />
<title>圖片檔案上傳</title>
<link type="text/css" rel="stylesheet" href="../css/main.css" />
<style>
<!--
	body {
		background: #cfcfcf;
		padding: 10px;
		text-align:center;
		height:20px;
	}
	#upload{
		margin:auto;
		margin-top:20px;
		margin-bottom:20px;
	}
	#upload div{
		padding-top:10px;
	}
	#upload div input{
		margin-right:30px;
	}
-->
</style>
</head>

<body>
	<form id="form1" name="form1" enctype="multipart/form-data" method="post" action="upimage.php">
		<input type="hidden" name="id" value="<?php echo $page->id; ?>" />
		<div id="upload">
			<div><input type="file" id="userfile" name="userfile" /> </div>
			<div><input type="button" id="btnOK" name="btnOK" value="確 定" class="btn" onClick="btn_click(this);" /><input type="button" id="btnCancel" name="btnCancel" value="返 回" class="btn" onClick="btn_click(this);" /></div>
		</div><!--#upload end-->
	</form>
</body>
</html>
<script language="javascript">
<!--
	function btn_click(sender){
		if(sender == document.getElementById("btnOK")){
			if(document.getElementById("userfile").value == ""){
				window.alert("請選擇要上傳的檔案!");
				return;
			}else{
				document.getElementById("form1").submit();
			}
		}else if(sender == document.getElementById("btnCancel")){
			parent.jQuery.fancybox.close();
		}
	}
//-->
</script>