<?php
	require_once "pageBase.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/customerDAL.php";
	require_once "../dal/commentDAL.php";

	class _customerList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('64')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dal = new customerDAL();
			$cl = parent::getPageParameter("cl","");
			$p = parent::getPageParameter("p","1");
			$pz = parent::getPageParameter("pz","40");
			parent::addParameter("cl",$cl);
			parent::addParameter("p",$p);
			parent::addParameter("pz",$pz);

			//搜尋條件
			$filter = "";
			if($cl != ""){
				$filter .= "a.`CustomerLevel`='".$cl."'";
			}

			//頁數參數
			$start = ((int)$p - 1) * (int)$pz;
			$rows = $dal->countRecordset($filter);

			//會員列表
			$data = $dal->executeRecordset($filter,"",$start,$pz);
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//頁導航
			if($rows > 0){
				$nm1 = $rows % $pz;
				$nm2 = ($rows - $nm1) / $pz;
				if($nm1 > 0)
					$nm2++;
				$nm3 = $p % 10;
				$nm4 = ($p - $nm3) / 10;
				if($nm3 == 0)
					$nm4--;
				$pagtxt = '<a data-action="goPage" data-id="';
				if($p == 1){
					$pagtxt .= "1";
				}else{
					$pagtxt .= ($p - 1);
				}
				$pagtxt .= '" href="javascript:void(0);">&lt; 上一頁</a>';
				for($i=1;$i<11;$i++){
					if($nm4 * 10 + $i == $p){
						$pagtxt .= '<span class="number_hit">'.$p.'</span>';
					}else{
						$pagtxt .= '<a data-action="goPage" data-id="'.($nm4 * 10 + $i).'" href="javascript:void(0);">'.($nm4 * 10 + $i).'</a>';
					}
					if($nm4 * 10 + $i == $nm2){
						$i = 12;
					}
				}
				$pagtxt .= '<a data-action="goPage" data-id="';
				if($p == $nm2){
					$pagtxt .= $nm2;
				}else{
					$pagtxt .= ($p + 1);
				}
				$pagtxt .= '" href="javascript:void(0);">下一頁 &gt;</a>';
			}else{
				$pagtxt = '沒有資料';
			}
			parent::addParameter("pagtxt",$pagtxt);

			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::addParameter("encodedUrl",urlencode(utility::getCurrentUrl()));
			parent::loadTemplateFile(dirname(__FILE__)."/templates/customerList.html");
			parent::loadData();
		}
		private function formatData($data){
			for($i=0;$i<count($data);$i++){
				$dalC = new commentDAL();
				switch($data[$i]["CustomerLevel"]){
					case "0":
						$data[$i]["LevelName"] = "普通會員";
						$data[$i]["AuthorityType"] = "delItem";
						$data[$i]["AuthorityName"] = "停權";
						break;
					case "-1":
						$data[$i]["LevelName"] = "停權會員";
						$data[$i]["AuthorityType"] = "recItem";
						$data[$i]["AuthorityName"] = "復權";
						break;
					default:
						$data[$i]["LevelName"] = "-";
						break;
				}
				if($data[$i]["FacebookID"] != ""){
					$data[$i]["Facebook"] = "<b style='color:#082cef;'>(FB帳號)</b>";
				}
				$data[$i]["CreatedTime"] = date("Y-m-d",strtotime($data[$i]["CreatedTime"]));
				$data[$i]["countC"] = $dalC->executeRecordset("a.`CustomerID`='".$data[$i]["CustomerID"]."' AND c.`ProductID`!='0' AND a.`Visible`='1'");
				$data[$i]["countC"] = count($data[$i]["countC"]);
				$data[$i]["encodedUrl"] = urlencode(utility::getCurrentUrl());
			}
			return $data;
		}
	}

	$page = new _customerList();
	$page->load();
	$page->render();
?>