<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/customerDAL.php";
	require_once "../dal/commentDAL.php";

	class _customerEdit extends pageBase{
		private $id,$pUrl;
		private $dal,$dalP,$dalS;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('64')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","customerList.php"));
			$this->dal = new customerDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->CustomerID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CustomerLevel",$this->dal->CustomerLevel);
				parent::addParameter("FacebookID",$this->dal->FacebookID);
				if($this->dal->FacebookID != ""){
					parent::addParameter("Facebook","<b style='color:#082cef;'>(FB帳號)</b>");
				}
				parent::addParameter("LoginName",$this->dal->LoginName);
				parent::addParameter("LoginPassword",$this->dal->LoginPassword);
				parent::addParameter("CustomerName",$this->dal->CustomerName);
				parent::addParameter("Mobile",$this->dal->Mobile);
				parent::addParameter("LineID",$this->dal->LineID);
				parent::addParameter("CreatedIP",$this->dal->CreatedIP);
				parent::addParameter("CreatedTime",$this->dal->CreatedTime);
				parent::addParameter("readonly"," readonly='readonly'");
				parent::addParameter("noneBox","");
				parent::addParameter("editTitle","修改會員資訊");
			}else{
				parent::addParameter("CustomerLevel","0");
				parent::addParameter("readonly","");
				parent::addParameter("noneBox"," style='display:none'");
				parent::addParameter("editTitle","新增會員資訊");
			}
			
			$dalC = new commentDAL();
			$data = $dalC->executeRecordset("a.`CustomerID`='".$this->dal->CustomerID."' AND c.`ProductID`!='0' AND a.`Visible`='1'");
			for($i=0;$i<count($data);$i++){
				$data[$i]["Stars"] = round($data[$i]["Stars"]);
				$data[$i]["StarsIcon"] = "";
				for($j=0;$j<$data[$i]["Stars"];$j++){
					$data[$i]["StarsIcon"] .= "<i class='fa fa-star light'></i>";
				}
				$data[$i]["Stars2"] = 5 - (int)$data[$i]["Stars"];
				for($k=0;$k<$data[$i]["Stars2"];$k++){
					$data[$i]["StarsIcon"] .= "<i class='fa fa-star'></i>";
				}
				if($data[$i]["Stars"] <= 0){
					$data[$i]["Stars"] = "";
				}
			}
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/customerEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->CustomerID = $this->id;
				$this->dal->loadRecord();
			}
			$this->dal->CustomerLevel = conver::toDbString(trim($_POST["CustomerLevel"]));
			$this->dal->LoginName = conver::toDbString(trim($_POST["LoginName"]));
			$this->dal->LoginPassword = conver::toDbString(trim($_POST["LoginPassword"]));
			$this->dal->CustomerName = conver::toDbString(trim($_POST["CustomerName"]));
			$this->dal->Mobile = conver::toDbString(trim($_POST["Mobile"]));
			$this->dal->LineID = conver::toDbString(trim($_POST["LineID"]));

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				if(!empty($_SERVER["HTTP_CLIENT_IP"])){
					$ip = $_SERVER["HTTP_CLIENT_IP"];
				}else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
					$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
				}else{
					$ip = $_SERVER["REMOTE_ADDR"];
				}
				$this->dal->CreatedIP = $ip;
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _customerEdit();
	$page->load();
	$page->render();
?>