<?php
	require_once "pageBase.php";
	require_once "../dal/count_lastDAL.php";
	require_once "../bin/web/repeater.php";

	class _countSearchEngine extends pageBase{

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('13')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dalL = new count_lastDAL();

			$aryT = array();
			for($i=0;$i<4;$i++){
				$aryT[$i] = array();
				$aryT[$i]["ym"] = date("Y-m", mktime(0, 0, 0, ((int)date("n")-$i), 1, date("Y")));
			}
			$listT = new repeater();
			$listT->id = "listT";
			$listT->dataSource = $aryT;
			parent::addControl($listT);

			$ym = parent::getPageParameter("ym", $aryT[0]["ym"]);
			parent::addParameter("ym", $ym);
			$filter = "a.`Time` LIKE '".$ym."%'";
			$dataL = $dalL->executeRecordset($filter);
			$aryC = array();
			$aryC[0] = array();
			$aryC[0]["title"] = "<img src='images/all/icon-all.png' /> 總瀏覽人次";
			$aryC[0]["count"] = 0;
			$aryC[0]["percent"] = "";
			$aryC[1] = array();
			$aryC[1]["title"] = "<img src='images/all/icon-yahoo.png' /> 來自Yahoo瀏覽人次";
			$aryC[1]["count"] = 0;
			$aryC[1]["percent"] = "";
			$aryC[2] = array();
			$aryC[2]["title"] = "<img src='images/all/icon-google.png' /> 來自Google瀏覽人次";
			$aryC[2]["count"] = 0;
			$aryC[2]["percent"] = "";
			$aryC[3] = array();
			$aryC[3]["title"] = "<img src='images/all/icon-baidu.png' /> 來自百度瀏覽人次";
			$aryC[3]["count"] = 0;
			$aryC[3]["percent"] = "";
			for($i=0;$i<count($dataL);$i++){
				$aryC[0]["count"]++;
				if(mb_strpos($dataL[$i]["RefererHost"], "yahoo.com", 0, "utf-8") !== false){
					$aryC[1]["count"]++;
				}else if(mb_strpos($dataL[$i]["RefererHost"], "google.com", 0, "utf-8") !== false){
					$aryC[2]["count"]++;
				}else if(mb_strpos($dataL[$i]["RefererHost"], "baidu.com", 0, "utf-8") !== false){
					$aryC[3]["count"]++;
				}
			}
			$aryC[1]["percent"] = "[".(round($aryC[1]["count"] / $aryC[0]["count"] * 10000) / 100)."&#37;]";
			$aryC[2]["percent"] = "[".(round($aryC[2]["count"] / $aryC[0]["count"] * 10000) / 100)."&#37;]";
			$aryC[3]["percent"] = "[".(round($aryC[3]["count"] / $aryC[0]["count"] * 10000) / 100)."&#37;]";
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $aryC;
			parent::addControl($listC);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/countSearchEngine.html");
			parent::loadData();
		}
	}

	$page = new _countSearchEngine();
	$page->load();
	$page->render();
?>