<?php
	require_once "pageBase.php";
	require_once "../dal/count_lastDAL.php";
	require_once "../bin/web/repeater.php";

	class _countIP extends pageBase{

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('13')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dalL = new count_lastDAL();

			$aryT = array();
			for($i=0;$i<4;$i++){
				$aryT[$i] = array();
				$aryT[$i]["ym"] = date("Y-m", mktime(0, 0, 0, ((int)date("n")-$i), 1, date("Y")));
			}
			$listT = new repeater();
			$listT->id = "listT";
			$listT->dataSource = $aryT;
			parent::addControl($listT);

			$ym = parent::getPageParameter("ym", $aryT[0]["ym"]);
			parent::addParameter("ym", $ym);
			$filter = "a.`Time` LIKE '".$ym."%'";
			$orderExp = "a.`IP`";
			$dataL = $dalL->executeRecordset($filter, $orderExp);
			$aryL = array();
			for($i=0;$i<count($dataL);$i++){
				if(count($aryL) == 0){
					$ary = array();
					$ary["IP"] = $dataL[$i]["IP"];
					$ary["IP2"] = urlencode($dataL[$i]["IP"]);
					$ary["ym"] = $ym;
					$ary["Count"] = 1;
					$aryL[] = $ary;
				}else if($dataL[$i]["IP"] == $aryL[count($aryL)-1]["IP"]){
					$aryL[count($aryL)-1]["Count"]++;
				}else{
					$ary = array();
					$ary["IP"] = $dataL[$i]["IP"];
					$ary["IP2"] = urlencode($dataL[$i]["IP"]);
					$ary["ym"] = $ym;
					$ary["Count"] = 1;
					$aryL[] = $ary;
				}
			}
			$listL = new repeater();
			$listL->id = "listL";
			$listL->dataSource = $aryL;
			parent::addControl($listL);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/countIP.html");
			parent::loadData();
		}
	}

	$page = new _countIP();
	$page->load();
	$page->render();
?>