<?php
	require_once "pageBase.php";
	require_once "../dal/count_lastDAL.php";
	require_once "../dal/count_totalDAL.php";
	require_once "../bin/web/repeater.php";

	class _countAnalyze extends pageBase{

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('13')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dalL = new count_lastDAL();
			$dalT = new count_totalDAL();
			$num1 = $dalT->countRecordset();
			$num2 = $dalT->countRecordset("a.`Date` LIKE '".date("Y")."%'");
			$num3 = $dalT->countRecordset("a.`Date` LIKE '".date("Y-m")."%'");
			$num4 = $dalT->countRecordset("a.`Date`='".date("Y-m-d")."'");
			parent::addParameter("num1","".$num1);
			parent::addParameter("num2","".$num2);
			parent::addParameter("num3","".$num3);
			parent::addParameter("num4","".$num4);
			parent::addParameter("date2",date("Y年"));
			parent::addParameter("date3",date("Y年m月"));
			parent::addParameter("date4",date("Y年m月d日"));
			$ylist = array();
			for($i=0;$i<12;$i++){
				$ydate = date("Y-m",mktime(0,0,0,($i+1),1,date("Y")));
				$ylist[$i]["date"] = date("m月",mktime(0,0,0,($i+1),1,date("Y")));
				$ylist[$i]["num"] = $dalT->countRecordset("a.`Date` LIKE '".$ydate."%'");
				if($i < 11){
					$ylist[$i]["last"] = ",";
				}else{
					$ylist[$i]["last"] = "";
				}
			}
			$listY = new repeater();
			$listY->id = "listY";
			$listY->dataSource = $ylist;
			parent::addControl($listY);
			$mlist = array();
			for($i=0;$i<31;$i++){
				if(mktime(0,0,0,date("m"),($i+1),date("Y")) > mktime(0,0,0,date("m")+1,0,date("Y"))){
					$i = 33;
				}else{
					$mdate = date("Y-m-d",mktime(0,0,0,date("m"),($i+1),date("Y")));
					$mlist[$i]["date"] = date("d日",mktime(0,0,0,date("m"),($i+1),date("Y")));
					$mlist[$i]["num"] = $dalT->countRecordset("a.`Date` LIKE '".$mdate."%'");
					if($i < 32){
						$mlist[$i]["last"] = ",";
					}else{
						$mlist[$i]["last"] = "";
					}
				}
			}
			$listM = new repeater();
			$listM->id = "listM";
			$listM->dataSource = $mlist;
			parent::addControl($listM);
			$dlist = array();
			for($i=0;$i<24;$i++){
				$ddate = date("Y-m-d H",mktime($i,0,0,date("m"),date("d"),date("Y")));
				$dlist[$i]["date"] = date("H時",mktime($i,0,0,date("m"),date("d"),date("Y")));
				$dlist[$i]["num"] = $dalL->countRecordset("a.`Time` LIKE '".$ddate."%'");
				if($i < 23){
					$dlist[$i]["last"] = ",";
				}else{
					$dlist[$i]["last"] = "";
				}
			}
			$listD = new repeater();
			$listD->id = "listD";
			$listD->dataSource = $dlist;
			parent::addControl($listD);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/countAnalyze.html");
			parent::loadData();
		}
	}

	$page = new _countAnalyze();
	$page->load();
	$page->render();
?>