<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/system/email.php";
	require_once "../bin/system/smtp_mail.php";
	require_once "../dal/contactDAL.php";
	require_once "../dal/registryDAL.php";

	class _contactView extends pageBase{
		private $id,$pUrl;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('28')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new contactDAL();
			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","contactList.php"));

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->ContactID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("Name",$this->dal->Name);
				parent::addParameter("Phone",$this->dal->Phone);
				parent::addParameter("Email",$this->dal->Email);
				parent::addParameter("ProductID",$this->dal->ProductID);
				parent::addParameter("ProductName",$this->dal->ProductName);
				parent::addParameter("Mobile",$this->dal->Mobile);
				parent::addParameter("Company",$this->dal->Company);
				parent::addParameter("Address",$this->dal->Address);
				parent::addParameter("Url",$this->dal->Url);
				parent::addParameter("Title",$this->dal->Title);
				parent::addParameter("Content",$this->dal->Content);
				if($this->dal->ReMail != ""){
					parent::addParameter("ReMail",$this->dal->ReMail);
				}else{
					parent::addParameter("ReMail",$this->dal->Email);
				}
				parent::addParameter("ReTitle",$this->dal->ReTitle);
				parent::addParameter("ReContent",$this->dal->ReContent);
				if($this->dal->IsReply == "0"){
					parent::addParameter("IsReply","<span style=\"color:#f00;\">&#10005</span>");
				}else{
					parent::addParameter("IsReply","<span style=\"color:#090;\">&#10003</span>");
				}
				parent::addParameter("CreatedIP",$this->dal->CreatedIP);
				parent::addParameter("CreatedTime",$this->dal->CreatedTime);

				//讀取狀態變更
				$this->dal->IsView = "1";
				$this->dal->ModifiedUserID = parent::getCurrentUserID();
				$this->dal->updateRecord();
			}else{
				parent::redirect($this->pUrl);
			}

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/contactView.html");
			parent::loadData();
		}
		public function saveData(){
			$this->dal->ContactID = $this->id;
			$this->dal->loadRecord();

			if(registryDAL::getRegistryValue("sendMailType") == ""){
				$email = new email();
				$email->toAddress = conver::toDbString(trim($_POST["ReMail"]));
	
				$email->fromAddress = "=?UTF-8?B?".base64_encode(registryDAL::getRegistryValue("webName"))."?= <".registryDAL::getRegistryValue("webEmail").">";
				$email->replyToAddress = "=?UTF-8?B?".base64_encode(registryDAL::getRegistryValue("webName"))."?= <".registryDAL::getRegistryValue("webEmail").">";
				$email->subject = conver::toDbString(trim($_POST["ReTitle"]));
				$email->content = stripslashes(trim($_POST["ReContent"]));
	
				if($email->send()){
					//變更回覆狀態
					$this->dal->ReMail = $email->toAddress;
					$this->dal->ReTitle = $email->subject;
					$this->dal->ReContent = trim($_POST["ReContent"]);
					$this->dal->IsReply = "1";
					$this->dal->ModifiedUserID = parent::getCurrentUserID();
					$this->dal->updateRecord();
					parent::alert("郵件已經發送成功!");
				}else{
					parent::alert("發送郵件時出現錯誤!");
				}
			}else{
				$toAry = array();
				$toAry[] = conver::toDbString(trim($_POST["ReMail"]));
				$smtp_mail = new smtp_mail();
				$smtp_mail->toAry = $toAry;
				$smtp_mail->name = "=?UTF-8?B?".base64_encode(registryDAL::getRegistryValue("webName"))."?=";
				$smtp_mail->subject = conver::toDbString(trim($_POST["ReTitle"]));
				$smtp_mail->body = stripslashes(trim($_POST["ReContent"]));
				if($smtp_mail->send()){
					//變更回覆狀態
					$this->dal->ReMail = $email->toAddress;
					$this->dal->ReTitle = $email->subject;
					$this->dal->ReContent = trim($_POST["ReContent"]);
					$this->dal->IsReply = "1";
					$this->dal->ModifiedUserID = parent::getCurrentUserID();
					$this->dal->updateRecord();
					parent::alert("郵件已經發送成功!");
				}else{
					parent::alert("發送郵件時出現錯誤!");
				}
			}
		}
	}

	$page = new _contactView();
	$page->load();
	$page->render();
?>