<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/registryDAL.php";
	class _contactSet extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('54')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}
		public function loadData(){
			$sideNavShow = registryDAL::getRegistryValue("sideNavShow");
			$arySN = explode(",",$sideNavShow);
			$dataSN = array();
			foreach($arySN as $value){
				$dataSN[]["Value"] = $value;
			}
			$listSN = new repeater();
			$listSN->id = "listSN";
			$listSN->dataSource = $dataSN;
			parent::addControl($listSN);
			
			$webContact = registryDAL::getRegistryValue("webContact");
			parent::addParameter("webContact",$webContact);
			
			$ContactName = registryDAL::getRegistryValue("ContactName");
			parent::addParameter("ContactName",$ContactName);	
					
			parent::loadTemplateFile(dirname(__FILE__)."/templates/contactSet.html");
			parent::loadData();
		}
		public function saveData(){
			$arySN = $_POST["sideNavShow"];
			if(isset($arySN)){
				$sideNavShow = implode(",",$arySN);
			}else{
				$sideNavShow = "";
			}

			$ContactName = conver::toDbString(trim($_POST["ContactName"]));
			
			$webContact = $_POST["webContact"];
			if(!get_magic_quotes_gpc()){
				$webContact = addslashes($webContact);
			}
			
			registryDAL::saveRegistry("sideNavShow",$sideNavShow);
			registryDAL::saveRegistry("ContactName",$ContactName);
			registryDAL::saveRegistry("webContact",$webContact);
			parent::redirect("contactSet.php");
		}
	}

	$page = new _contactSet();
	$page->load();
	$page->render();
?>