<?php
	require_once "pageBase.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/contactDAL.php";

	class _contactList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('28')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dal = new contactDAL();
			$kw = parent::getPageParameter("kw","");
			$pz = parent::getPageParameter("pz","40");
			$p = parent::getPageParameter("p","1");
			parent::addParameter("kw",$kw);
			parent::addParameter("pz",$pz);
			parent::addParameter("p",$p);

			//過濾表達式
			$filter = "a.`Name` LIKE '%".$kw."%' OR a.`Phone` LIKE '%".$kw."%' OR a.`Email` LIKE '%".$kw."%' OR a.`Title` LIKE '%".$kw."%'";

			//頁數參數
			$start = ((int)$p - 1) * (int)$pz;
			$rows = $dal->countRecordset($filter);

			//聯絡我們列表
			$data = $dal->executeRecordset($filter,"",$start,$pz);
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//頁導航
			if($rows > 0){
				$nm1 = $rows % $pz;
				$nm2 = ($rows - $nm1) / $pz;
				if($nm1 > 0)
					$nm2++;
				$nm3 = $p % 10;
				$nm4 = ($p - $nm3) / 10;
				if($nm3 == 0)
					$nm4--;
				$pagtxt = '<a data-action="goPage" data-id="';
				if($p == 1){
					$pagtxt .= "1";
				}else{
					$pagtxt .= ($p - 1);
				}
				$pagtxt .= '" href="javascript:void(0);">&lt; 上一頁</a>';
				for($i=1;$i<11;$i++){
					if($nm4 * 10 + $i == $p){
						$pagtxt .= '<span class="number_hit">'.$p.'</span>';
					}else{
						$pagtxt .= '<a data-action="goPage" data-id="'.($nm4 * 10 + $i).'" href="javascript:void(0);">'.($nm4 * 10 + $i).'</a>';
					}
					if($nm4 * 10 + $i == $nm2){
						$i = 12;
					}
				}
				$pagtxt .= '<a data-action="goPage" data-id="';
				if($p == $nm2){
					$pagtxt .= $nm2;
				}else{
					$pagtxt .= ($p + 1);
				}
				$pagtxt .= '" href="javascript:void(0);">下一頁 &gt;</a>';
			}else{
				$pagtxt = '沒有資料';
			}
			parent::addParameter("pagtxt",$pagtxt);

			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::loadTemplateFile(dirname(__FILE__)."/templates/contactList.html");
			parent::loadData();
		}
		public function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["IsView"] == "1")
					$data[$i]["IsView"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["IsView"] = "<span style=\"color:#f00;\">&#10005</span>";
				if($data[$i]["IsReply"] == "1")
					$data[$i]["IsReply"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["IsReply"] = "<span style=\"color:#f00;\">&#10005</span>";

				$data[$i]["CreatedDate"] = date("Y-m-d",strtotime($data[$i]["CreatedTime"]));
				$data[$i]["encodedUrl"] = urlencode(utility::getCurrentUrl());
			}
			return $data;
		}
	}

	$page = new _contactList();
	$page->load();
	$page->render();
?>