<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/customerDAL.php";
	require_once "../dal/productDAL.php";
	require_once "../dal/commentDAL.php";

	class _commentAdd extends pageBase{
		private $pUrl,$pid;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('18')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}
			$this->pid = parent::getPageParameter("pid","0");
			if($this->pid == "0"){
				$this->pUrl = urldecode(parent::getPageParameter("pUrl","productList.php"));
			}else{
				$this->pUrl = urldecode(parent::getPageParameter("pUrl","productEdit.php?id=".$this->pid));
			}
			
			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}

		public function loadData(){
			//會員
			$dalC = new customerDAL();
			$dataC = $dalC->executeRecordset("a.`CustomerID`!='0'","a.`CustomerLevel` DESC");
			for($i=0;$i<count($dataC);$i++){
				if($dataC[$i]["CustomerLevel"] == "-1"){
					$dataC[$i]["Level"] = "【停權會員】";
				}else{
					$dataC[$i]["Level"] = " 【".$dataC[$i]["LoginName"]."】";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);
			
			//產品
			$dalP = new productDAL();
			$dataP = $dalP->executeRecordset("a.`ProductID`!='0'","c.`OrderNO`,b.`OrderNO`,a.`OrderNO`,a.`CreatedTime` DESC");
			for($i=0;$i<count($dataP);$i++){
				$dataP[$i]["AverageStar"] = round($dataP[$i]["AverageStar"]);
				if($dataP[$i]["AverageStar"] <= 0){
					$dataP[$i]["AverageStar"] = "0";
				}
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $dataP;
			parent::addControl($listP);

			parent::addParameter("editTitle","新增評論");

			parent::addParameter("pUrl",$this->pUrl);
			parent::addParameter("pid",$this->pid);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/commentAdd.html");
			parent::loadData();
		}
		public function saveData(){
			$dal = new commentDAL();
			$dal->CustomerID = conver::toDbString(trim($_POST["CustomerID"]));
			$dal->ProductID = conver::toDbString(trim($_POST["ProductID"]));
			$dal->Stars = conver::toDbString(trim($_POST["Stars"]));
			$dal->Image = conver::toDbString(trim($_POST["Image"]));
			$dal->Content = conver::toDbString(trim($_POST["Content"]));
			$dal->Visible = "1";
			if(!empty($_SERVER["HTTP_CLIENT_IP"])){
				$ip = $_SERVER["HTTP_CLIENT_IP"];
			}else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
				$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
			}else{
				$ip = $_SERVER["REMOTE_ADDR"];
			}
			$dal->CreatedIP = $ip;
			$CreatedTime = conver::toDbString(trim($_POST["CreatedTime"]));
			if($CreatedTime == ""){
				$dal->CreatedTime = date("Y-m-d H:i:s");
			}else{
				$dal->CreatedTime = $CreatedTime;
			}

			$saved = false;
			$saved = $dal->insertRecord();
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _commentAdd();
	$page->load();
	$page->render();
?>