<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/bookDAL.php";
	require_once "../dal/book_categoryDAL.php";
	require_once "../dal/photoDAL.php";

	class _bookEdit extends pageBase{
		private $id,$pUrl;
		private $dal,$dalC;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('26')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","bookList.php"));
			$this->dal = new bookDAL();
			$this->dalC = new book_categoryDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->BookID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryID",$this->dal->CategoryID);
				parent::addParameter("BookName",$this->dal->BookName);
				parent::addParameter("Image",$this->dal->Image);
				parent::addParameter("Description",$this->dal->Description);
				parent::addParameter("IsIndex",$this->dal->IsIndex);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("WebTitle",$this->dal->WebTitle);
				parent::addParameter("WebKeyword",$this->dal->WebKeyword);
				parent::addParameter("WebDescription",$this->dal->WebDescription);
				parent::addParameter("editTitle","修改相本內容");
			}else{
				parent::addParameter("IsIndex","1");
				parent::addParameter("Visible","1");
				parent::addParameter("editTitle","新增相本");
			}

			//分類下拉
			$dataC = $this->dalC->executeRecordset("a.`Visible`='1'");
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//相片/影片列表
			$dalP = new photoDAL();
			$dataP = $dalP->executeRecordset("a.`BookID`='".$this->id."'");
			for($i=0;$i<count($dataP);$i++){
				if($dataP[$i]["PhotoType"] == "1"){
					$dataP[$i]["PhotoTypeName"] = "相片";
				}else if($dataP[$i]["PhotoType"] == "2"){
					$dataP[$i]["PhotoTypeName"] = "影片";
					$dataP[$i]["Image"] = str_replace("https://youtu.be/","https://img.youtube.com/vi/",$dataP[$i]["Movie"])."/0.jpg";
				}
				$dataP[$i]["encodedUrl"] = urlencode(utility::getCurrentUrl());
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $dataP;
			parent::addControl($listP);

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::loadTemplateFile(dirname(__FILE__)."/templates/bookEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->BookID = $this->id;
				$this->dal->loadRecord();
			}
			$this->dal->CategoryID = conver::toDbString(trim($_POST["CategoryID"]));
			$this->dal->BookName = conver::toDbString(trim($_POST["BookName"]));
			$this->dal->Image = conver::toDbString(trim($_POST["Image"]));
			$this->dal->Description = conver::toDbString(trim($_POST["Description"]));
			$this->dal->IsIndex = conver::toDbString(trim($_POST["IsIndex"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"]) ? $_POST["OrderNO"] : 0;
			$this->dal->WebTitle = conver::toDbString(trim($_POST["WebTitle"]));
			$this->dal->WebTitle = str_replace("\r\n","",$this->dal->WebTitle);
			if(trim($this->dal->WebTitle) == "")
				$this->dal->WebTitle = $this->dal->BookName;
			$this->dal->WebKeyword = conver::toDbString(trim($_POST["WebKeyword"]));
			$this->dal->WebKeyword = str_replace("\r\n","",$this->dal->WebKeyword);
			if(trim($this->dal->WebKeyword) == ""){
				$this->dalC->CategoryID = $this->dal->CategoryID;
				$this->dalC->loadRecord();
				$this->dal->WebKeyword = $this->dal->BookName.",".$this->dalC->CategoryName;
			}
			$this->dal->WebDescription = conver::toDbString(trim($_POST["WebDescription"]));
			$this->dal->WebDescription = str_replace("\r\n","",$this->dal->WebDescription);
			if(trim($this->dal->WebDescription) == "")
				$this->dal->WebDescription = substr(preg_replace("/\s/","",str_replace("\r\n","",strip_tags($this->dal->Description))),0,150);

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _bookEdit();
	$page->load();
	$page->render();
?>