<?php
	require_once "pageBase.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/autokeywordDAL.php";
	require_once "../dal/autokeywordlinkDAL.php";

	class _autokeywordList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('58')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dal = new autokeywordDAL();
			$dalL = new autokeywordlinkDAL();

			//
			$data = $dal->executeRecordset();
			//關鍵字下拉
			$listK = new repeater();
			$listK->id = "listK";
			$listK->dataSource = $data;
			parent::addControl($listK);

			//關鍵字-連結列表
			$aryL = array();
			for($i=0;$i<count($data);$i++){
				$ary1 = array();
				$ary1["td1"] = "<input type='radio' name='Important' value='".$data[$i]["KeywordID"]."'>";
				$ary1["td2"] = $data[$i]["KeywordTitle"];
				$ary2["tdStyle"] = " style='text-align:left; padding-left:5px;'";
				$ary1["td3"] = "<a data-id='".$data[$i]["KeywordID"]."' data-action='delKey' href='javascript:void(0);'>刪除</a>";
				if($i % 2 == 0){
					$ary1["trStyle"] = " style='background-color:#9FF;'";
				}else{
					$ary1["trStyle"] = " style='background-color:#FFA;'";
				}
				$aryL[] = $ary1;

				$dataL = $dalL->executeRecordset("a.KeywordID='".$data[$i]["KeywordID"]."'");
				for($j=0;$j<count($dataL);$j++){
					$ary2 = array();
					$ary2["td1"] = "";
					$ary2["td2"] = $dataL[$j]["LinkURL"];
					$ary2["tdStyle"] = " style='text-align:left; padding-left:15px;'";
					$ary2["td3"] = "<a data-id='".$dataL[$j]["ID"]."' data-action='delLink' href='javascript:void(0);'>刪除</a>";
					if($j % 2 == 0){
						$ary2["trStyle"] = " style='background-color:#FCF;'";
					}else{
						$ary2["trStyle"] = " style='background-color:#AFF;'";
					}
					$aryL[] = $ary2;
				}
			}
			$listL = new repeater();
			$listL->id = "listL";
			$listL->dataSource = $aryL;
			parent::addControl($listL);
			
			//重要關鍵字
			$dataI = $dal->executeRecordset("a.Important='1'","",0,1);
			if(count($dataI) == 0){
				$importantID = "0";
			}else{
				$importantID = $dataI[0]["KeywordID"];
			}
			parent::addParameter("ImportantID",$importantID);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/autokeywordList.html");
			parent::loadData();
		}
	}

	$page = new _autokeywordList();
	$page->load();
	$page->render();
?>