<?php
	require_once "pageBase.php";
	require_once "../dal/article_categoryDAL.php";
	require_once "../bin/system/conver.php";

	class _article_categoryEdit extends pageBase{
		private $id;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('20')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->dal = new article_categoryDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->CategoryID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryName",$this->dal->CategoryName);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("editTitle","修改文章分類資訊");
			}else{
				$dataO = $this->dal->executeRecordset("","a.`OrderNO` DESC",0,1);
				if(count($dataO) == 0){
					$orderNO = "10";
				}else{
					$orderNO = "".((int)$dataO[0]["OrderNO"] + 10);
				}
				parent::addParameter("Visible","1");
				parent::addParameter("OrderNO",$orderNO);
				parent::addParameter("editTitle","新增文章分類");
			}
			parent::addParameter("id",$this->id);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/article_categoryEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->CategoryID = $this->id;
				$this->dal->loadRecord();
			}
			$this->dal->CategoryName = conver::toDbString(trim($_POST["CategoryName"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"])?$_POST["OrderNO"]:0;

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect("article_categoryList.php");
			}
		}
	}

	$page = new _article_categoryEdit();
	$page->load();
	$page->render();
?>