<?php
	require_once "pageBase.php";
	require_once "../dal/articleDAL.php";
	require_once "../bin/web/repeater.php";

	class _articleList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('21')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dal = new articleDAL();
			$data = $dal->executeRecordset();
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/articleList.html");
			parent::loadData();
		}

		private function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["Visible"] == "1")
					$data[$i]["Visible"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["Visible"] = "<span style=\"color:#f00;\">&#10005</span>";

				$data[$i]["htLink"] = $this->htLink1;
			}
			return $data;
		}
	}

	$page = new _articleList();
	$page->load();
	$page->render();
?>