<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/articleDAL.php";
	require_once "../dal/article_categoryDAL.php";

	class _articleEdit extends pageBase{
		private $id;
		private $dal,$dalC;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('21')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->dal = new articleDAL();
			$this->dalC = new article_categoryDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->ArticleID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryID",$this->dal->CategoryID);
				parent::addParameter("Title",$this->dal->Title);
				parent::addParameter("PathName",$this->dal->PathName);
				parent::addParameter("Description",$this->dal->Description);
				parent::addParameter("Image",$this->dal->Image);
				parent::addParameter("Structure",$this->dal->Structure);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("WebTitle",$this->dal->WebTitle);
				parent::addParameter("WebKeyword",$this->dal->WebKeyword);
				parent::addParameter("WebDescription",$this->dal->WebDescription);
				parent::addParameter("editTitle","修改文章內容");
			}else{
				parent::addParameter("Structure","1");
				parent::addParameter("Visible","1");
				parent::addParameter("editTitle","新增文章");
			}

			$dataC = $this->dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				if($i == 0){
					$dataC[$i]["checked"] = " checked='checked'";					 
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			parent::addParameter("id",$this->id);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/articleEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->ArticleID = $this->id;
				$this->dal->loadRecord();
			}else{
				$this->dal->CreatedUserID = parent::getCurrentUserID();
			}
			$this->dal->CategoryID = conver::toDbString(trim($_POST["CategoryID"]));
			$this->dal->Title = conver::toDbString(trim($_POST["Title"]));
			$pathName = conver::toDbString(trim($_POST["PathName"]));
			$this->dal->Description = conver::toDbString(trim($_POST["Description"]));
			$this->dal->Image = conver::toDbString(trim($_POST["Image"]));
			$this->dal->Structure = conver::toDbString(trim($_POST["Structure"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"])?$_POST["OrderNO"]:0;
			$this->dal->WebTitle = conver::toDbString(trim($_POST["WebTitle"]));
			$this->dal->WebTitle = str_replace("\r\n","",$this->dal->WebTitle);
			if($this->dal->WebTitle == "")
				$this->dal->WebTitle = $this->dal->Title;
			$this->dal->WebKeyword = conver::toDbString(trim($_POST["WebKeyword"]));
			$this->dal->WebKeyword = str_replace("\r\n","",$this->dal->WebKeyword);
			if($this->dal->WebKeyword == ""){
				$this->dalC->CategoryID = $this->dal->CategoryID;
				$this->dalC->loadRecord();
				$this->dal->WebKeyword = $this->dal->Title.",".$this->dalC->CategoryName;
			}
			$this->dal->WebDescription = conver::toDbString(trim($_POST["WebDescription"]));
			$this->dal->WebDescription = str_replace("\r\n","",$this->dal->WebDescription);
			if($this->dal->WebDescription == "")
				$this->dal->WebDescription = substr(preg_replace("/\s/","",str_replace("\r\n","",strip_tags($this->dal->Description))),0,150);
			$this->dal->ModifiedUserID = parent::getCurrentUserID();

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				//判斷路徑名稱是否重複
				if($this->dal->checkPathNameExists($pathName) && $this->dal->PathName != $pathName){
					parent::alert("路徑名稱\\\"".$pathName."\\\"已經存在！");
					exit;
				}
				$this->dal->PathName = $pathName;
				$saved = $this->dal->updateRecord();
			}else{
				//判斷路徑名稱是否重複
				if($this->dal->checkPathNameExists($pathName)){
					parent::alert("路徑名稱\\\"".$pathName."\\\"已經存在！");
					exit;
				}
				$this->dal->PathName = $pathName;
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect("articleList.php");
			}
		}
	}

	$page = new _articleEdit();
	$page->load();
	$page->render();
?>