<?php
	require_once "../bin/system/conver.php";
	require_once "../dal/productDAL.php";
	require_once "../dal/registryDAL.php";

	$action = conver::toDbString(trim($_POST["do"]));
	switch($action){
		case "add":
			addItem();
			break;
		case "chg":
			chgQuantity();
			break;
		case "sum":
			sumPrice();
			break;
		case "del":
			delItem();
			break;
		case "clean":
			clean();
			break;
		default:
			break;
	}
	
	function addItem(){													//新增產品到購物車中
		$dal = new productDAL();
		$id = conver::toDbString(trim($_POST["id"]));
		$q = conver::toDbString(trim($_POST["q"]));
		$q = (int)$q;

		$dal->ProductID = $id;
		$dal->loadRecord();

		if($dal->Visible == "1" && $dal->CategoryVisible == "1" && ($dal->ParentVisible == "1" || $dal->ParentID == "0") && $q > 0){	//檢查產品
			if(isset($_COOKIE["cart"])){								//已經有產品在購物車中
				//取得購物車資料
				$cart = $_COOKIE["cart"];
				$cart = str_replace('\"','"',$cart);
				$cartAry = json_decode($cart);
				//檢查產品是否重複加入購物車
				$flag = 0;
				foreach($cartAry as $row){
					if($row->id == $id){
						$flag = 1;
						break;
					}
				}
				if($flag == 0){											//購物車中沒有此項產品
					$ary = array();
					$ary["id"] = $id;
					$ary["q"] = $q;
					$cartAry[] = $ary;
					$cart = json_encode($cartAry);
					setcookie("cart",$cart,0,"/");
					//回傳
					$reCode = array();
					$reCode["flag"] = "1";
					$reCode["Msg"] = urlencode("產品加入購物車成功!");
					echo urldecode(json_encode($reCode));
				}else{													//購物車中已有相同產品
					//回傳
					$reCode = array();
					$reCode["flag"] = "0";
					$reCode["Msg"] = urlencode("購物車中已有相同產品!");
					echo urldecode(json_encode($reCode));
				}
			}else{														//尚未有產品在購物車中
				$cartAry = array();
				$ary = array();
				$ary["id"] = $id;
				$ary["q"] = $q;
				$cartAry[] = $ary;
				$cart = json_encode($cartAry);
				setcookie("cart",$cart,0,"/");
				//回傳
				$reCode = array();
				$reCode["flag"] = "1";
				$reCode["Msg"] = urlencode("產品加入購物車成功!");
				echo urldecode(json_encode($reCode));
			}
		}else{															//產品不存在、已下架、產品分類已關閉、產品數量錯誤
			//回傳
			$reCode = array();
			$reCode["flag"] = "0";
			$reCode["Msg"] = urlencode("產品加入購物車失敗!");
			echo urldecode(json_encode($reCode));
		}
	}
	
	function chgQuantity(){												//修改產品數量
		$dal = new productDAL();
		$id = conver::toDbString(trim($_POST["id"]));
		$q = conver::toDbString(trim($_POST["q"]));
		$q = (int)$q;
		$amount = 0;
		if(isset($_COOKIE["cart"])){									//已經有產品在購物車中
			//取得購物車資料
			$cart = $_COOKIE["cart"];
			$cart = str_replace('\"','"',$cart);
			$cartAry = json_decode($cart);
			//檢查產品是否重複加入購物車
			$flag = 0;
			for($i=0;$i<count($cartAry);$i++){
				if($cartAry[$i]->id == $id){
					$dal->ProductID = $id;
					$dal->loadRecord();
					$flag = 1;
					$cartAry[$i]->q = $q;
					$amount = $q * (int)$dal->Price;
					break;
				}
			}
			if($flag == 0){												//購物車中沒有此項產品
				//回傳
				$reCode = array();
				$reCode["flag"] = "0";
				$reCode["Msg"] = urlencode("購物車中沒有此項產品!");
				echo urldecode(json_encode($reCode));
			}else{														//產品數量已修改
				array_values($cartAry);
				$cart = json_encode($cartAry);
				setcookie("cart",$cart,0,"/");
				//回傳
				$reCode = array();
				$reCode["flag"] = "1";
				$reCode["Msg"] = urlencode("修改產品數量成功!");
				$reCode["Amount"] = "".$amount;
				echo urldecode(json_encode($reCode));
			}
		}else{															//購物車是空的
			//回傳
			$reCode = array();
			$reCode["flag"] = "0";
			$reCode["Msg"] = urlencode("購物車中沒有產品!");
			echo urldecode(json_encode($reCode));
		}
	}
	
	function sumPrice(){												//計算總金額
		if(isset($_COOKIE["cart"])){									//已經有產品在購物車中
			$dal = new productDAL();
			$transPrice = registryDAL::getRegistryValue("transPrice");
			$transFreePrice = registryDAL::getRegistryValue("transFreePrice");
			//取得購物車資料
			$cart = $_COOKIE["cart"];
			$cart = str_replace('\"','"',$cart);
			$cartAry = json_decode($cart);
			$newCartAry = array();
			//計算金額
			$price = 0;
			$flag = 0;													//檢查是否有產品被系統移出購物車
			$errName = '';
			foreach($cartAry as $row){
				$dal->ProductID = $row->id;
				$dal->loadRecord();
				if($dal->Visible == "1" && $dal->CategoryVisible == "1" && ($dal->ParentVisible == "1" || $dal->ParentID == "0") && (int)$row->q > 0){
					$ary = array();
					$ary["id"] = $row->id;
					$ary["q"] = $row->q;
					$newCartAry[] = $ary;
					$price += ((int)$dal->Price * (int)$row->q);
				}else{
					$flag = 1;
					if($errName != '')
						$errName .= '、';
					$errName .= $dal->ProductName;
				}
			}
			//回傳
			$reCode = array();
			if($flag == 0){												//系統沒有移除任何產品
				$reCode["flag"] = "1";
			}else{														//系統有移除產品
				$reCode["flag"] = "0";
				$reCode["Msg"] = urlencode("產品「".$errName."」已被下架!系統已自動將產品從購物車中移出!");
				$cart = json_encode($newCartAry);
				setcookie("cart",$cart,0,"/");
			}
			$reCode["price1"] = "".$price;
			if($price >= (int)$transFreePrice){
				$reCode["price2"] = "0";
				$reCode["price3"] = "".$price;
			}else{
				$reCode["price2"] = $transPrice;
				$reCode["price3"] = "".($price + $transPrice);
			}
			echo urldecode(json_encode($reCode));
		}else{															//購物車是空的
			//回傳
			$reCode = array();
			$reCode["flag"] = "0";
			$reCode["Msg"] = urlencode("購物車中沒有產品!");
			echo urldecode(json_encode($reCode));
		}
	}
	
	function delItem(){													//刪除購物車中指定產品
		$id = conver::toDbString(trim($_POST["id"]));
		if(isset($_COOKIE["cart"])){									//已經有產品在購物車中
			//取得購物車資料
			$cart = $_COOKIE["cart"];
			$cart = str_replace('\"','"',$cart);
			$cartAry = json_decode($cart);
			//檢查產品是否重複加入購物車
			$flag = 0;
			for($i=0;$i<count($cartAry);$i++){
				if($cartAry[$i]->id == $id){
					$flag = 1;
					unset($cartAry[$i]);
					break;
				}
			}
			if($flag == 0){												//購物車中沒有此項產品
				//回傳
				$reCode = array();
				$reCode["flag"] = "0";
				$reCode["Msg"] = urlencode("購物車中沒有此項產品!");
				echo urldecode(json_encode($reCode));
			}else{														//產品已刪除
				array_values($cartAry);
				$cart = json_encode($cartAry);
				setcookie("cart",$cart,0,"/");
				//回傳
				$reCode = array();
				$reCode["flag"] = "1";
				$reCode["Msg"] = urlencode("刪除產品成功!");
				echo urldecode(json_encode($reCode));
			}
		}else{															//購物車是空的
			//回傳
			$reCode = array();
			$reCode["flag"] = "0";
			$reCode["Msg"] = urlencode("購物車中沒有產品!");
			echo urldecode(json_encode($reCode));
		}
	}

	function clean(){													//清空購物車
		setcookie("cart","",0,"/");
		//回傳
		$reCode = array();
		$reCode["flag"] = "1";
		$reCode["Msg"] = urlencode("購物車已清空!");
		echo urldecode(json_encode($reCode));
	}
?>